function v = Guess_lin(x)

global n m gamma Aeff %#ok<*GVMIS> 

Is0=1e-6;                   % Intensity of signal
Ip0=2e-6;                   % Intensity of pump          
as=0.125*log(10)*1e-4;      % alpha_s    
ap=0.24*log(10)*1e-4;       % alpha_p
wp=1.455*1e-6;
ws=1.555*1e-6;
g=7e-14;

K1=1e-2;
K2=1e-1;
A=(-Is0*(as*gamma-g*Ip0))/gamma;
D=(-Ip0*(ap*ws*gamma+wp*g*Is0))/(ws*gamma);
E=(-1/2*(wp*g*Ip0*A+wp*g*D*Is0+ap*D*ws*gamma))/(ws*gamma);
B=(-1/2*(-g*Ip0*A-g*D*Is0+as*A*gamma))/gamma;
C=(1/3*(g*Ip0*B+g*D*A+g*E*Is0-as*B*gamma))/gamma;
F=(-1/3*(wp*g*Ip0*B+wp*g*D*A+wp*g*E*Is0+ap*E*ws*gamma))/(ws*gamma);

%%%%%%%%%%%%%%%%% Backward-pumping %%%%%%%%%%%%%%%%
Guess_for_signals=K1*(Is0+A*x+B*x^2+C*x^3)*Aeff;
Guess_for_pumps=-K2*(Ip0+D*x+E*x^2+F*x^3)*Aeff;
%%%%%%%%%%%%%%%%% Forward-pumping %%%%%%%%%%%%%%%%%
% Guess_for_signals=K1*(Is0+A*x+B*x^2+C*x^3)*Aeff;
% Guess_for_pumps=K1*(Ip0+D*x+E*x^2+F*x^3)*Aeff;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

v=zeros(m+n,1);
v(1:n)=Guess_for_pumps;
v(n+1:n+m)=Guess_for_signals;

end